#include "derivative.h"
#include "TFT.h"
#include "img1.h"
#include "Rend_Characters.h"
#include "FIR.h"
#include "HeartRate.h"
#include "ButtonsHandler.h"


extern UINT8 chs = 0;
extern UINT8 u8TouchDetect;
UINT16 i_sweep, j_sweep, cnt = 0;
UINT8 v1 = 52, v2 = 52;
UINT8 cntexit = 0;


void TFT_init(void)
{  
  
  Fulldisplay(Convert_888_to_565(Black,HIGHBYTE),Convert_888_to_565(Black,LOWBYTE));
  vfnPrint_SD_Image("HEART.AMI",0,0);
  New_fntcolor(White,Black);
  
  comm_out(0x2A);								  // Column Address Set
  data_out(0x00);	
  data_out(0x15);								    // Start Column xs
  data_out(0x00);
  data_out(0x7F);								    // End Column xe

  comm_out(0x2B);								  // Line Address Set
  data_out(0x00);
  data_out(0x00);							      // Start Line ys
  data_out(0x00);
  data_out(160); 						      // End Line ye
  
  comm_out(0x2C);	                // Write to Frame Memory
	
	RS = 1;	 							          // Data Register 
}

/****************************************************************************/

void screen_sweep(void)
{   
  
  for(i_sweep=0;i_sweep<160;i_sweep++)				     // 160 Lines
    { 
              
       delayTouch(90);
       
       ECG_ENABLE=OFF;
       TSS_Task();
       ECG_ENABLE=ON;   
       
       if(gu8ButtonStatus==BUTTON_EXIT)
          break;
       
       v2 = (UINT8)((FilterOutput>>3)-100);
       
       if(v2>166){
          v2=166;
       }
       if(v2<60){
          v2=60;
       }
         
       for(j_sweep=60;j_sweep<167;j_sweep++)				 // 107 Pixels/Line
       {
       		
      
						if( (j_sweep>=v1 && j_sweep<=v2) || (j_sweep>=v2 && j_sweep<=v1) )
						{
						  VALOR(0x0F);       // High 8 Bits              
						  WR1  = 0;		
						  WR1  = 1;		       // Clock in Data
						
						  VALOR(0x00);       // Low 8 Bits
						  WR1  = 0;		
						  WR1  = 1;						  
						}
						else
						{
						  VALOR(0x00);       // High 8 Bits
						  WR1  = 0;		
						  WR1  = 1;		       // Clock in Data
						
						  VALOR(0x00);       // Low 8 Bits
						  WR1  = 0;		
						  WR1  = 1;
						}				
						
          }
      v1 = v2;
      
    } 	 
}

/******************************************************/


/*********************************************************************/
/*                             Delay                                 */
/*********************************************************************/

void delay(UINT16 n)
{
	UINT16 i,j;
	for (i=0;i<n;i++){
	  
  		for (j=0;j<350;j++)
  			{;}
	}
}

/*********************************************************************/
/*                       Delay Touch                                 */
/*********************************************************************/

void delayTouch(UINT16 n)
{
	UINT16 i,j;
	for (i=0;i<n;i++){
  	for (j=0;j<350;j++)
  	{	
  	if(gu8FilterTimeElapsed){
        Sample_number++;
     
        filter_execution(); 
        HR_periodic_task((UINT16)(FilterOutput));
  
        }
     }
	}
}



/*********************************************************************/
/*                           Data Output                             */
/*********************************************************************/

void data_out(UINT8 i)          // Data Output 8-bit Bus Interface
{
	RS   = 1;							        // Data Register
	RD1  = 1;							        // Read Disable
	WR1  = 0;							        // Write Enable
	VALOR(i); 						        // Put Byte on Port
	WR1  = 1;							        // Clock in Data
}

/*********************************************************************/
/*                         Command Output                            */
/*********************************************************************/

void comm_out(UINT8 j)          // Command Output 8-bit Bus Interface
{                                 
	RS   = 0;							        // Instruction Register
	RD1  = 1;							        // Read Disable
	WR1  = 0;							        // Write enable
	VALOR(j);								      // Put byte on Port
	WR1  = 1;							        // Clock in Data
}

/*********************************************************************/
/*                    Full Display with RGB color                    */
/*********************************************************************/

void Fulldisplay(UINT8 d1,UINT8 d2)
{
	UINT16 i,j;
	RS = 1;	 							        // Data Register
	
	for(i=0;i<160;i++)				    // 160 Lines
    {
       for(j=0;j<128;j++)				// 128 Pixels/Line
          {
		  		VALOR(d1);				    // High 8 Bits
          WR1  = 0;
				  WR1  = 1;				      // Clock in Data
				  
				  VALOR(d2);				    // Low 8 Bits
          WR1  = 0;
				  WR1  = 1;				      // Clock in Data
          }
    }
}

/*********************************************************************/
/*                          Display Picture                          */
/*********************************************************************/

void dispPic(const UINT8 *lcd_string)     // Display a 16bpp, 128x160 Pixels Bitmap
{
	UINT16 i,j;
	RS = 1;	 							                  // Data Register

	for(i=0;i<160;i++)	  				          // Write 160 Lines of Picture Data
   		{		
     		for(j=0;j<128;j++)		            // Write 128 Pixels/Line
      			{
						VALOR((char)*lcd_string);     // High 8 Bits
						WR1 = 0;	
						WR1 = 1;		                  // Clock in Data
						
						VALOR((char)*(++lcd_string)); // Low 8 Bits
						WR1 = 0;	
						WR1 = 1;		                  // Clock in Data
						
						lcd_string++;	                // Point to next Byte of Picture Data
    		 	  }
   		}  		
} 
 

/*********************************************************************/
/*                        Display Colored Area                       */
/*********************************************************************/

void colorArea(unsigned char xs, unsigned char xe, unsigned char ys, unsigned char ye, unsigned char d1, unsigned char d2)
{
	UINT16 i,j;
	
  comm_out(0x2A);								  // Column Address Set
  data_out(0x00);	
  data_out(xs);								    // Start Column xs
  data_out(0x00);
  data_out(xe);								    // End Column xe

  comm_out(0x2B);								  // Line Address Set
  data_out(0x00);
  data_out(ys);							      // Start Line ys
  data_out(0x00);
  data_out(ye); 						      // End Line ye
  
  comm_out(0x2C);	                // Write to Frame Memory
	
	RS = 1;	 							          // Data Register
	
	for(i=0;i<(xe-xs+1);i++)			  // 160 Lines
    {
       for(j=0;j<(ye-ys+1);j++)	  // 128 Pixels/Line
          {
		  		VALOR(d1);				      // High 8 Bits
          WR1 = 0;
				  WR1 = 1;				        // Clock in Data
				  
				  VALOR(d2);				      // Low 8 Bits
          WR1 = 0;
				  WR1 = 1;				        // Clock in Data
          }
    }
    
  comm_out(0x2A);								  // Column Address Set
  data_out(0x00);	
  data_out(0x00);								  // Start Column 0x0000 = 0
  data_out(0x00);
  data_out(0x7F);								  // End Column 0x007F = 127

  comm_out(0x2B);								  // Line Address Set
  data_out(0x00);
  data_out(0x00);							    // Start Line 0x0000 = 0
  data_out(0x00);
  data_out(0x9F); 						    // End Line 0x009F = 159
  
  comm_out(0x2C);		              // Write to Frame Memory
}

/*********************************************************************/
/*                        Display Picture Area                       */
/*********************************************************************/

void picArea(UINT8 xs, UINT8 xe, UINT8 ys, UINT8 ye, const UINT8 *lcd_string)
{
	UINT16 i,j;
	UINT8 string;
	
  comm_out(0x2A);								  // Column Address Set
  data_out(0x00);	
  data_out(xs);								    // Start Column xs
  data_out(0x00);
  data_out(xe);								    // End Column xe

  comm_out(0x2B);								  // Line Address Set
  data_out(0x00);
  data_out(ys);							      // Start Line ys
  data_out(0x00);
  data_out(ye); 						      // End Line ye
  
  comm_out(0x2C);	                // Write to Frame Memory
	
	RS = 1;	 							                    // Data register
	
	for(i=0;i<(xe-xs+1);i++)				          // 160 Lines
    {
       for(j=0;j<(ye-ys+1);j++)				      // 128 Pixels/Line
          {
						string = (UINT8)*lcd_string;       // High 8 Bits
						VALOR(string);
						WR1 = 0;		
						WR1 = 1;		                    // Clock in Data
						
						string = (UINT8)*(++lcd_string);   // Low 8 Bits
						VALOR(string);
						WR1 = 0;		
						WR1 = 1;		                    // Clock in Data
						
						lcd_string++;	                  // Point to next Byte of Picture Data
          }
    }
    
  comm_out(0x2A);								  // Column Address Set
  data_out(0x00);	
  data_out(0x00);								  // Start Column 0x0000 = 0
  data_out(0x00);
  data_out(0x7F);								  // End Column 0x007F = 127

  comm_out(0x2B);								  // Line Address Set
  data_out(0x00);
  data_out(0x00);							    // Start Line 0x0000 = 0
  data_out(0x00);
  data_out(0x9F); 						    // End Line 0x009F = 159
  
  comm_out(0x2C);		              // Write to Frame Memory
}

/*********************************************************************/
/*                        Display ECG Graph                          */
/*********************************************************************/

void plotECG() 
{
  
}

/*********************************************************************/
/*                        TFT_RESET For ILI9163                          */
/*********************************************************************/

void resetLCD()
{
	TFT_RESET = 0;
	delay(100);
	TFT_RESET = 1;
	delay(100);
}

/*********************************************************************/
/*                  Initialization For ILI9163                       */
/*********************************************************************/

void init_LCD() 
{
CS = 0;										                        // Chip Select = Active
comm_out(0x11); 							                    // Exit Sleep Mode
delay(100);
comm_out(0x26); data_out(0x04);				            // Set Gamma Curve 3
comm_out(0xF2); data_out(0x00);				            // Gamma Adjustment Enabled
comm_out(0xB1); data_out(0x0A);	data_out(0x14);	  // Frame Rate
comm_out(0xC0); data_out(0x0A);	data_out(0x00);	  // Power Control 1
comm_out(0xC1); data_out(0x02);				            // Power Control 2
comm_out(0xC5); data_out(0x2F);	data_out(0x3E);	  // VCOM Control 1
comm_out(0xC7); data_out(0x40);				            // VCOM Offset Control
comm_out(0x2A);								                    // Column Address Set
data_out(0x00);	
data_out(0x00);								                    // Start Column 0x0000 = 0
data_out(0x00);
data_out(0x7F);								                    // End Column 0x007F = 127
comm_out(0x2B);								                    // Line Address Set
data_out(0x00);
data_out(0x00);							                      // Start Line 0x0000 = 0
data_out(0x00);
data_out(0x9F); 						                    	// End Line 0x009F = 159
comm_out(0x36); data_out(0xC0);		            		// Memory Access Control
comm_out(0x3A); data_out(0xC5);		            		// Pixel Format = 16bit/pixel
comm_out(0x29);						                    		// Display On
comm_out(0x2C);		                            		// Write to Frame Memory (begin writing data)
}